//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.2
import QtGraphicalEffects 1.0

import wesual.Controls 1.0

/*!
    \qmltype Flayout
    \since 5.1
    \inqmlmodule QmlContols
    \ingroup QmlControls
    \brief Provides a top-level application window.

    This is in qml context
*/

Popup {
    id : flyout

    default property Item contentItem

    property int contentMargins : 4
    property int edge : Control.TopEdge

    width : Math.max(contentItem.implicitWidth + 2 * contentMargins, 32)
    height : Math.max(contentItem.implicitHeight + 2 * contentMargins, 32)

    onContentItemChanged : {
        contentItem.parent = flyout
        contentItem.anchors.fill = flyout;
        contentItem.anchors.margins = Qt.binding(function() {
            return flyout.contentMargins;
        });
    }

    QtObject {
        id : p_

        function clipped(value, dimension) {
            return Math.max(peak.width / 2,
                            Math.min(dimension - peak.width / 2, value));
        }
    }
    Rectangle {
        id : content

        anchors.fill : parent
        border {
            //color : "#BEB9A6"
            color : UI.color(UI.PrimaryControlBorder)
            width : 1
        }

        Item {
            rotation : {
                switch (flyout.edge) {
                case Control.TopEdge:
                    return 0;
                case Control.RightEdge:
                    return 90;
                case Control.BottomEdge:
                    return 180;
                case Control.LeftEdge:
                    return 270;
                }
            }

            x : {
                switch (flyout.edge) {
                case Control.TopEdge:
                case Control.BottomEdge:
                    return p_.clipped(flyout.hotspot.x, flyout.width);
                case Control.LeftEdge:
                    return 1;
                case Control.RightEdge:
                    return flyout.width - 1;
                }
            }

            y : {
                switch (flyout.edge) {
                case Control.TopEdge:
                    return 1;
                case Control.BottomEdge:
                    return flyout.height - 1;
                case Control.RightEdge:
                case Control.LeftEdge:
                    return p_.clipped(flyout.hotspot.y, flyout.height);
                }
            }

            Image {
                id : peak
                anchors.bottom : parent.bottom
                anchors.horizontalCenter : parent.horizontalCenter
                source : "qrc:/controls/images/flyout-peak.png"
            }
        }
    }
}
